/////////////////////////////////////////////////////////////
// CINEMA SDK : ANIMATION																	 //
/////////////////////////////////////////////////////////////
// VERSION    : CINEMA 4D																	 //
/////////////////////////////////////////////////////////////
// (c) 1989-2002 MAXON Computer GmbH, all rights reserved	 //
/////////////////////////////////////////////////////////////

// "blinker" animation effect example

#include "c4d.h"
#include "c4d_symbols.h"
#include "KEblinker.h"
#include "SEblinker.h"

class BlinkerKey : public KeyData
{
	public:
		virtual Bool Init(GeListNode *node);
		static NodeData *Alloc(void) { return gNew BlinkerKey; }
};

class BlinkerSequence : public SequenceData
{
	public:
		virtual Bool Init(GeListNode *node);
		static NodeData *Alloc(void) { return gNew BlinkerSequence; }
};

class BlinkerTrack : public TrackData
{
	public:
		virtual Bool Animate(PluginTrack *track, BaseDocument *doc, BaseList2D *op, BaseSequence *seq, const BaseTime &time, LONG fps, Real fac, Real rel, BaseKey *k1, BaseKey *k2, LONG flags);

		static NodeData *Alloc(void) { return gNew BlinkerTrack; }
};


Bool BlinkerKey::Init(GeListNode *node)
{
	BaseContainer *data = ((BaseKey*)node)->GetDataInstance();

	data->SetReal(BLINKERKEY_NUMBER,1.0);

	return TRUE;
}

Bool BlinkerSequence::Init(GeListNode *node)
{
	BaseContainer *data = ((BaseSequence*)node)->GetDataInstance();

	data->SetBool(BLINKERSEQUENCE_TEST,TRUE);

	return TRUE;
}

Bool BlinkerTrack::Animate(PluginTrack *pl, BaseDocument *doc, BaseList2D *op, BaseSequence *seq, const BaseTime &time, LONG fps, Real fac, Real rel, BaseKey *k1, BaseKey *k2, LONG flags)
{
	if ((!k1 && !k2) || !op->IsInstanceOf(Obase)) return TRUE;

	BaseContainer *b1,*b2;
	BaseTime      t;
	Real					number=0.0;
	
	if (k1)	b1 = k1->GetDataInstance();
	if (k2) b2 = k2->GetDataInstance();

	if (k1 && k2)
	{
		number	 = b1->GetReal(BLINKERKEY_NUMBER)*(1.0-rel)+b2->GetReal(BLINKERKEY_NUMBER)*rel;
	}
	else if (k1)
	{
		number   = b1->GetReal(BLINKERKEY_NUMBER);
	}
	else if (k2)
	{
		number   = b1->GetReal(BLINKERKEY_NUMBER);
	}

	LONG mode;
	Real v=Sin(number*fac*pi2);
	if (v>=0.0)
		mode=MODE_ON;
	else
		mode=MODE_OFF;

	((BaseObject*)op)->SetEditorMode(mode);

	return TRUE;
}

// be sure to use a unique ID obtained from www.plugincafe.com
#define ID_BLINKERANIMATION	1001152

Bool RegisterBlinker(void)
{
	// decide by name if the plugin shall be registered - just for user convenience
	String name=GeLoadString(IDS_BLINKER); if (!name.Content()) return TRUE;

	return RegisterKeyPlugin(ID_BLINKERANIMATION,name,0,BlinkerKey::Alloc,"KEblinker",0) &&
				 RegisterSequencePlugin(ID_BLINKERANIMATION,name,0,BlinkerSequence::Alloc,"SEblinker",0) &&
				 RegisterTrackPlugin(ID_BLINKERANIMATION,name,ANIMINFO_QUICK,BlinkerTrack::Alloc,0);
}
